//#define TEST

#include "idda_main.h"

idda_main::idda_main()
{
	mapcount = 0;
}

idda_main::~idda_main()
{
}

void idda_main::run (int argc, char** argv) 
{
#ifdef TEST
//	_chdir ("c:\\games\\quake2\\baseq2\\demos");
	_chdir ("c:\\");
	argc = 2;
	argv[1] = "s*.dm2";
#endif
	if (argc < 2) help();	
	char configpath[260];
	config = new configdata[1];
	config->get_configpath (configpath, argv[0]);
	config->read_options(argc, argv);
#ifdef TEST
	strcpy (configpath, "c:\\pool\\homepage\\idda1\\idda1.cfg");
//	strcpy (configpath, "c:\\games\\quake2\\baseq2\\demos\\idda1.cfg");
#endif
	if (config->userconfig == false) {
		config->read_configfile (configpath);
	} else {
		config->read_configfile (config->userconfigfile);
	}
	if (argc == 2) {
		config->html = true;
		config->open_all = true;
		config->temp_output = true;
	}
#ifdef TEST
//	config->write_kills_per_time_graph = true;
//	config->write_ways_and_kills_graph = true;
//	config->html = true;
//	config->write_idda_log = true;
//	config->open_all = false;
#endif
	if (config->single == false) {
		analyze (argv[1]);
	} else {
		_finddata_t finddata;
		int handle = _findfirst (argv[1], &finddata);
		int done = handle;
		while (done != -1) {
			if ((finddata.attrib != _A_SUBDIR) && (finddata.name[0] != '.')) {
				analyze (finddata.name);
			}
			done = _findnext (handle, &finddata);
		}
	}
	delete[] config;
}

void idda_main::analyze (char* pathstr) 
{
	clock_t start, finish;   
	error err;
	_finddata_t finddata;
	printf ("\n\n");
	start = clock();
	data = new demodata[1];
	result = new resultdata[1];
	int handle = _findfirst (pathstr, &finddata);
	int done = handle;
	int len_total = 0;
	char nametemp[260];
	result->calculate (config);
	while (done != -1) {
		if ((finddata.attrib != _A_SUBDIR) && (finddata.name[0] != '.')) {
			strcpy (nametemp, finddata.name);
			current_name = finddata.name;
			int i = strlen (nametemp);
			while ((nametemp[--i] != '.') && (i >= 0));
			nametemp[++i] = 0;
			int demofile = _open (finddata.name, _O_BINARY);
			if (demofile == -1) {
				err.msg_and_exit ("Couldn't open demofile %s!", finddata.name);
			}
			int len = _filelength (demofile);
			len_total += len;
			char* buf = new char[len+1];
			printf ("Reading %s [%i byte]\n", finddata.name, len);
			_read (demofile, buf, len);
			_close (demofile);
			data->add (0, 100, finddata.name, 0);
			char temp[260];
			_itoa (len, temp, 10);
			data->add (0, 101, temp, 0);
			strcpy (temp, finddata.name);
			if (strstr (_strupr(temp), ".DM2") > temp) {
				if ((config->gametype != gt_dm2) && (config->gametype != gt_none)) {
					err.msg_and_exit ("Mixed demo types not allowed!");
				}
				config->gametype = gt_dm2;
				parsedemo_q2 demo (buf, len);
				demo.log (data, config);
			} else if (strstr (_strupr(temp), ".LOG") > temp) {
				if ((config->gametype != gt_log) && (config->gametype != gt_none)) {
					err.msg_and_exit ("Mixed demo types not allowed!");
				}
				config->gametype = gt_log;
				config->no_times = true;
				config->sortorder_players[0] = so_frags;
				parsedemo_log demo (buf, len);
				demo.log (data, config);
			} else if (strstr (_strupr(temp), ".QWD") > temp) {
				if ((config->gametype != gt_qwd) && (config->gametype != gt_none)) {
					err.msg_and_exit ("Mixed demo types not allowed!");
				}
				config->gametype = gt_qwd;
				config->no_times = true;
				config->sortorder_players[0] = so_frags;
				parsedemo_qw demo (buf, len);
				demo.log (data, config);
			}
			delete[] buf;
		}
		done = _findnext (handle, &finddata);
	}
	printf ("\nTotal: %i byte\n", len_total);
	printf ("\nAnalyzing\n");
	analyzedemo (config, data, result);
	if (config->dont_del_nps == false) {
		printf ("\nDeleting nullplayers\n");
		result->delete_nullplayers(); 
	}
	write_logs ();
	if (config->gametype == gt_dm2) {
		write_graphs ();
	}
	write_results();
	open_results();
	open_logs ();
	open_graphs ();
	delete[] result;
	delete[] data;
	finish = clock();
	printf ("\n");
	output_time ((double) (finish - start) / CLOCKS_PER_SEC);
}

void idda_main::output_time (double time)
{
	printf( "\n%.2f seconds elapsed\n", time);
}

void idda_main::write_logs ()
{
	char filename[260];
	write_log log;
	if (config->write_idda_log == true) {
		get_prefix (filename);
		if (config->single == true) {
			strcat (filename, "_");
		}
		strcat (filename, "idda.log");
		printf ("\nWriting %s", filename);
		log.write_idda_log (data, filename);
	}
	if (config->write_console_log == true) {
		get_prefix (filename);
		if (config->single == true) {
			strcat (filename, "_");
		}
		strcat (filename, "console.log");
		printf ("\nWriting %s", filename);
		log.write_console_log (data, filename);
	}
	if (config->write_console_log_html == true) {
		get_prefix (filename);
		if (config->single == true) {
			strcat (filename, "_");
		}
		strcat (filename, "console_log.htm");
		printf ("\nWriting %s", filename);
		log.write_console_log_html (data, filename);
	}
}

void idda_main::write_graphs ()
{
	char filename[260];
	if (config->write_kills_per_time_graph == true) {
		write_graph graph;
		get_prefix (filename);
		if (config->single == true) {
			strcat (filename, "_");
		}
		strcat (filename, "kills_per_time.tga");
		printf ("\nWriting %s", filename);
		graph.build (640, 480);
		graph.kills_per_time (data->get_first(), result);
		graph.write (filename);
	}
	if (config->write_ways_and_kills_graph == true) {
		mapcount = make_maplist (maplist, data);
		for (int i = 0; i < mapcount; i++) {
			int coord_count = 0;
			int ksd_count = 0;
			write_graph graph;
			graph.build (640, 480);
			demodata_t* pos = data->get_first_of_type(4);
			while (pos != 0) {
				if (strcmp (maplist[i], pos->message) == 0) {
					graph.calculate_max_values (pos);
				}
				pos = pos->next_of_type;
			}
			pos = data->get_first_of_type(4);
			while (pos != 0) {
				if (strcmp (maplist[i], pos->message) == 0) {
					int color_low[3] = { 0, 255, 0 };
					int color_high[3] = { 0, 0, 255 };
					coord_count += graph.player_ways (pos, color_low, color_high);
					ksd_count += graph.ksd_distribution (pos);
				}
				pos = pos->next_of_type;
			}
			if ((ksd_count > 0) || (coord_count > 50)) {
				get_prefix (filename);
				if (config->single == true) {
					strcat (filename, "_");
				}
				sprintf (filename+strlen(filename), "ways_and_kills (%s).tga", maplist[i]);
				printf ("\nWriting %s", filename);
				graph.write (filename);
			} else {
				maplist[i] = 0;
			}
		}
	}
}

void idda_main::write_results()
{
	if (config->html == true) {
		char htmlfile[260];
		output out_html (config, result, data);
		get_prefix (htmlfile);
		if (config->single == false) {
			strcat (htmlfile, config->htmlfile);
		} else {
			strcat (htmlfile, ".htm");
		}
		printf ("\nWriting %s", htmlfile);
		out_html.open (htmlfile);
		out_html.html_header();
		if (config->is_lmctf == true) {
			out_html.sort_players (so_team, so_ctf_score);
		}
		if (result->get_player_count() == 0) {
			out_html.empty_html();
		} else {
			out_html.general_info_html();
			out_html.demos_html();
			if (config->no_claninfo == false) {
				out_html.clan_info();
			}
			out_html.team_info_ctf();
			if (config->is_battle == true) {
				out_html.team_info();
			}
			out_html.player_info_ctf();
			out_html.sort_players(config->sortorder_players[0], config->sortorder_players[1]);
			out_html.player_ranking_html();
			out_html.player_info_html();
			out_html.kills_by_weapons_html(config->kills_by_weapons);
			out_html.deaths_html();
			if (int test = result->get_total_kills(0) > 0) {
				out_html.kills_html(0);	
			}
			if (config->weaponkills == true) {
				for (int i = 1; i < config->get_weapon_count(); i++) {
					if (int test = result->get_total_kills(i) > 0) {
						out_html.kills_html(i);	
					}
				}
			}
		}
		result->sort_players (so_name);
		result->sort_players (so_kills);
//		out_html.kpt_players();
		out_html.html_footer();
		out_html.close();
	}
}

void idda_main::get_prefix(char *str)
{
	str[0] = 0;
	if (config->temp_output == true) {
		strcpy (str, config->get_temppath());
	}
	if (config->single == true) {
		strcat (str, current_name);
		int i = 0;
		while ((str[i] != '.') && (str[i] != 0)) {
			i++;
		}
		str[i] = 0;
	}
	_strlwr (str);
}

void idda_main::open_results()
{
	if ((config->html == true) && ((config->open_results == true) || (config->open_all == true))) {
		printf ("\n");
		char htmlfile[260];
		get_prefix (htmlfile);
		if (config->single == false) {
			strcat (htmlfile, config->htmlfile);
		} else {
			strcat (htmlfile, ".htm");
		}
		printf ("\nTrying to open htmlfile (command: \"%s\")", 
			config->get_open_command(htmlfile));
		system (config->get_open_command(htmlfile));
	}
}

void idda_main::open_logs()
{
	if ((config->open_logs == true) || (config->open_all == true)) {
		printf ("\n");
		char filename[260];
		write_log log;
		if (config->write_console_log_html == true) {
			get_prefix (filename);
			if (config->single == true) {
				strcat (filename, "_");
			}
			strcat (filename, "console_log.htm");
			printf ("\nTrying to open html log (command: \"%s\")", 
				config->get_open_command(filename));
			system (config->get_open_command(filename));
		}
	}
}

void idda_main::open_graphs()
{
	if ((config->open_graphs == true) || (config->open_all == true)) {
		printf ("\n");
		char filename[260];
		if (config->write_kills_per_time_graph == true) {
			get_prefix (filename);
			if (config->single == true) {
				strcat (filename, "_");
			}
			strcat (filename, "kills_per_time.tga");
			printf ("\nTrying to open kills graph (command: \"%s\")", 
				config->get_open_command(filename));
			system (config->get_open_command(filename));
		}
		if (config->write_ways_and_kills_graph == true) {
			for (int i = 0; i < mapcount; i++) {
				if (maplist[i] == 0) {
					continue;
				}
				filename[0] = '\"';
				filename[1] = 0;
				get_prefix (filename+1);
				if (config->single == true) {
					strcat (filename, "_");
				}
				sprintf (filename+strlen(filename), "ways_and_kills (%s).tga\"", maplist[i]);
				printf ("\nTrying to open kills graph (\"%s\")", 
					config->get_open_command(filename));
				system (config->get_open_command(filename));
			}
		}
	}
}

int idda_main::make_maplist(char** maplist, demodata* data)
{
	int mapcount = 0;
	demodata_t* pos = data->get_first_of_type(4);
	while (pos != 0) {
		bool exists = false;
		for (int i = 0; i < mapcount; i++) {
			if (strcmp (maplist[i], pos->message) == 0) {
				exists = true;
			}
		}
		if (exists == false) {
			maplist[mapcount++] = pos->message;
		}
		pos = pos->next_of_type;
	}
	return mapcount;
}

void idda_main::help () 
{
    printf ("\n%s %s, %s\n%s\n", helpstr1, version, date, helpstr2);
	printf ("\n*** THIS IS A DEVELOPMENT BUILD! ***");
	printf ("\n***  WORKS WITH QW/Q2 AND LOGS!  ***\n");
    printf ("\nUsage: idDA <demoname> [OPTIONS]\n");
    printf ("\nOptions:\n");
	printf ("\n/a               open all created files after analysis");
	printf ("\n/ag              open graph(s) after analysis");
	printf ("\n/ah              open html result file(s) after analysis");
	printf ("\n/al              open log file(s) after analysis");
	printf ("\n/b<0-3>          kills by weapons chart type (default: /b0)");
	printf ("\n/c:<filename>    use custom config file");
	printf ("\n/d               don't delete \"nullplayers\"");
	printf ("\n/g<k|t>[+]       write graph(s) (ways+kills, kills/time; '+': all clients)");
	printf ("\n/h[:<filename>]  write results to HTML-file(s) (default: \"result->htm\")");
	printf ("\n/l<i|c|h>        write log(s) (idda, console, html)");
	printf ("\n/nc              don't output clan info");
	printf ("\n/nk              don't output killcharts");
	printf ("\n/nz              don't align center, but align left");
	printf ("\n/o<1>[<2>]       primary and secondary sortorder of players (r/s/f/n/k/c/t/1/2)");
	printf ("\n/s               single demo analysis");
	printf ("\n/temp            create all files in tempdir");
	printf ("\n/t<x>            only output top x players");
	printf ("\n/w               show killchart for each weapon");
	printf ("\n\nWildcards are allowed, i. e. \"IDDA *.*\".");
	printf ("\n\nIf you don't specify any options, /h /a /temp is default.\n");
	exit (0);
}
